#include "defaultCmds.h"
IC_Command_ECHO::IC_Command_ECHO() : IC_Command(L"echo")
{
	setUsage(L"echo <string>");
	addDescLine(L"This command echoes the given string to console");
}

IC_Command_ECHO::~IC_Command_ECHO()
{
}

bool IC_Command_ECHO::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	if(args.size() > 0)
	{
		WideString wstr = args[0];
		for(u32 i = 1; i < args.size(); i++)
		{
			wstr += L" ";
			wstr += args[i];
		}
		pOutput.logConsoleA(wstr);
	}
	return true;
}

//**************************************************************************************
IC_Command_HELP::IC_Command_HELP() : IC_Command(L"help")
{
	setUsage(L"help <cmd-name>");
	addDescLine(L"This command prints the help available for console commands.");
	addDescLine(L"To get a list of all available commands type \"cmdlist\".");
	//addDescLine(L"if cmd-name is not supplied a list of commands is printed with usage");
	//addDescLine(L"any command has to be preceded with the backslash character to execute");
	//addDescLine(L"e.g. \\help");
}

IC_Command_HELP::~IC_Command_HELP()
{
}

bool IC_Command_HELP::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	if(args.size() == 0) 
	{
		pOutput.printCommandDesc(L"help", &pOutput);
		return true;
	}
	//{
	//	pDispatcher->printCommandList(pOutput, true);
	//}
	//else

	WideString wstr = args[0];
	for(u32 i = 1; i < args.size(); i++)
	{
		wstr += L" ";
		wstr += args[i];
	}
	if(pOutput.hasCommand(wstr))
	{
		pOutput.printCommandDesc(wstr, &pOutput);
	}
	else
	{
		WideString msg = "No help available for command [";
		msg+= wstr;
		msg+="].";
		pOutput.logConsoleError(msg);
	}

	return true;
}

//**************************************************************************************

IC_Command_LIST::IC_Command_LIST(): IC_Command(L"cmdlist")
{
	setUsage("list <detailed>");
	addDescLine("This command lists all available commands.");
	addDescLine("If an additional paramter is specified then the command");
	addDescLine("displays detailed information for all commands.");
}

IC_Command_LIST::~IC_Command_LIST()
{
}

bool IC_Command_LIST::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	if(args.size() > 0)
	{
		pOutput.printCommandList(&pOutput, true);
	}
	else
	{
		pOutput.printCommandList(&pOutput, false);
	}
	return true;
}

//**************************************************************************************

IC_Command_DRIVER_INFO::IC_Command_DRIVER_INFO() : IC_Command("driver_info")
{
	setUsage("driver_info");
	addDescLine("This command prints some info about the engine.");

}

IC_Command_DRIVER_INFO::~IC_Command_DRIVER_INFO()
{
}

bool IC_Command_DRIVER_INFO::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	if( pOutput.pDevice )
	{
		WideString wstr = L" Irrlicht Version: ";
		wstr+= pOutput.pDevice->getVersion();
		pOutput.logConsoleA(wstr);

		wstr = L" OS Version: ";
		wstr+= pOutput.pDevice->getOSOperator()->getOperationSystemVersion();
		pOutput.logConsoleA(wstr);

		wstr = L" Display Driver: ";
		wstr+= pOutput.pDevice->getVideoDriver()->getName();
		pOutput.logConsoleA(wstr);

		wstr=L"";
		return true;
	}
	else
	{
		throw IC_Error(L"No valid irrlicht device detected!!");
	}
}

//**************************************************************************************

IC_Command_EXIT::IC_Command_EXIT() : IC_Command(L"exit")
{
	setUsage("exit");
	addDescLine("Sets the console to invisible.");
}

IC_Command_EXIT::~IC_Command_EXIT()
{
}

bool IC_Command_EXIT::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	pOutput.toggleVisible();
	return true;
}

//**************************************************************************************

IC_Command_QUIT::IC_Command_QUIT() : IC_Command(L"quit")
{
	setUsage("quit");
	addDescLine("Stops the aplication.");
}

IC_Command_QUIT::~IC_Command_QUIT()
{
}

bool IC_Command_QUIT::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	exit(0);
	return true;
}

//**************************************************************************************

IC_Command_CLS::IC_Command_CLS() : IC_Command(L"cls")
{
	setUsage("cls");
	addDescLine("Clears the console messages.");
}

IC_Command_CLS::~IC_Command_CLS()
{
}

bool IC_Command_CLS::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	pOutput.clearMessages();
	return true;
}

//**************************************************************************************

IC_Command_CONSOLECOLORS::IC_Command_CONSOLECOLORS() : IC_Command(L"consolecolors")
{
	setUsage("consolecolors");
	addDescLine("Prints the currently used console colors.");
}

IC_Command_CONSOLECOLORS::~IC_Command_CONSOLECOLORS()
{
}

bool IC_Command_CONSOLECOLORS::invoke(const array<WideString> &args, IC_Console &pOutput)
{
	pOutput.logInfo(L"Color of a <info> message from irrlicht.");
	pOutput.logError(L"Color of a <erro> message from irrlicht.");
	pOutput.logConsoleA(L"Color of a <cona> message from console.");
	pOutput.logConsoleB(L"Color of a <conb> message from console.");
	pOutput.logConsoleError(L"Color of a <cone> message from console.");
	return true;
}

