/*
* Neural Networks Tearm Project
* Martin Johne
* 04.10.2006
*/
#pragma once

//! A Class to work with integer numbers of different sizes.
class CLargeInteger
{
public:
	// construktors
	CLargeInteger(unsigned short sizeInBytes);
	CLargeInteger(unsigned long initialValue, unsigned short sizeInBytes);
	 // copie constructor
	CLargeInteger(const CLargeInteger &copy);

	// destrucktor
	~CLargeInteger(void);

	// different methods
	const char* toString();
	const char* toHexString();
	const char* toBinString();
	// intern division function
	// devides the number and returns the modulo
	unsigned short divideAndGiveCarry(unsigned short divisor);
	CLargeInteger pow(CLargeInteger &base, unsigned long exponent);
	void pow(unsigned long exponent);
	void setZero();
	void shiftLeftMax16(unsigned shift);
	void shiftRightMax16(unsigned shift);



public:
	// overloaded operators */
	//bool operator == (const CLargeInteger &number);
	bool operator == (const unsigned short number);
	//bool operator == (const unsigned long number);
	bool operator > (const CLargeInteger &compareLarger);
	bool operator < (const CLargeInteger &compareSmaller);
	
	CLargeInteger& operator = (const CLargeInteger &assign);
	CLargeInteger& operator = (const unsigned long assign);

	CLargeInteger  operator +  (const CLargeInteger &add);
	CLargeInteger  operator +  (const unsigned long add);
	CLargeInteger& operator += (const CLargeInteger &add);
	CLargeInteger& operator += (const unsigned long add);
	CLargeInteger& operator ++ (void);



	
//	template<class T> T operator++(T x, int) {return x++;}
	
	CLargeInteger  operator * (const CLargeInteger &mul);
	//CLargeInteger  operator * (unsigned long mul);
	CLargeInteger& operator *= (const CLargeInteger &mul);
	//CLargeInteger& operator *= (unsigned long mul);
	
	CLargeInteger  operator / (const CLargeInteger &div);
	//CLargeInteger  operator / (unsigned long div);
	//CLargeInteger& operator /= (const CLargeInteger &div);
	//CLargeInteger& operator /= (unsigned long div);

	CLargeInteger  operator ^  (long exponent);
	CLargeInteger& operator ^= (long exponent);
	



private:
	char negative;
	unsigned short *pNumber;
	unsigned short sizeShorts; // number of shorts the Number uses
	char *pOutString; // takes the Number as String when requested
};
