/*
* Neural Networks Tearm Project
* Martin Johne
* 04.10.2006
*/
#pragma once
#include <irrlicht.h>
#include "Symmetry.h"

//! Provides a lookup table for a very good tic tac toe player.
class CLookUpTable
{
public:

	// methods

	CLookUpTable();
	~CLookUpTable(void);

	//! Learns the lookup table to play the game.
	void learn();
	//! Gives the probability to win from the given state on.
	double getStateValue(char *pBoard);
	//! Returns the move which is ratet as best next move.
	int getBestMove(char *pBoard, char player);

	// variables

	irr::core::array<unsigned long> lookUpTableStates;
	irr::core::array<double> lookUpStateValues;

private:

	//methods

	void createTables();
	inline unsigned long reduceBoardToLong(const char *pBoard);

	// variables
	
	int boardSizeX, boardSizeY, boardSizeZ;
	int winFieldCount;
	int boardFieldsCount;
	CSymmetry *pSymmetry;
	char *pBoard;
	
};
