/*
* Neural Networks Tearm Project
* Martin Johne
* 04.10.2006
*/

#pragma once

#include <irrlicht.h>
#include "IrrConsole/console.h"
#include "Symmetry.h"

using namespace irr;


#define EMTY_FIELD			 0
#define PLAYER_1			 1
#define PLAYER_2			 2
#define PLAYER_TYPE_HUMAN	 0
#define PLAYER_TYPE_AINN	 1
#define PLAYER_TYPE_AILT	 2

// definition of id values for GUI elements
// menu ID's
#define ID_MENU_GAME_QUIT			50
#define ID_MENU_GAME_PREFERENCES	51
#define ID_MENU_AI_COMPETITION		52
#define ID_MENU_AI_NN_SETUP			53
#define ID_MENU_HELP				54

// gerneric ID's
#define ID_BUTTON_GENERAL_CLOSE		55

// preferences window id's
#define ID_EDIT_X					60
#define ID_EDIT_Y					61
#define ID_EDIT_Z					62
#define ID_CHECK_HUMAN1				63
#define ID_CHECK_HUMAN2				64
#define ID_CHECK_AINN1				65
#define ID_CHECK_AINN2				66
#define ID_CHECK_AILT1				67
#define ID_CHECK_AILT2				68
#define ID_BUTTON_NNSETUP			69
#define ID_BUTTON_CLOSE_PREF		70
#define ID_BUTTON_AICOMPETITION		71
#define ID_EDIT_CONNECT				73
#define ID_BUTTON_SET				74

// AI competition window id's
#define ID_CHECK_WEAKEN1			80
#define ID_CHECK_WEAKEN2			81
#define ID_BUTTON_START_COMPETITION	82
#define ID_BUTTON_CLOSE_COMP		84

// Neural Network window id's
#define ID_BUTTON_CLOSE_NN			90
#define ID_BUTTON_START_TRAINING	91
#define ID_BUTTON_STOP_TRAINING		92
#define ID_BUTTON_CONTINUE_TRAINING	93
#define ID_BUTTON_LOAD_NET			95
#define ID_BUTTON_SAVE_NET			96
#define ID_BUTTON_SAVE_DEFAULT		97
#define ID_BUTTON_LOAD_DEFAULT		98
#define ID_BUTTON_TRAIN_SURE		99
#define ID_CHECK_LARGE_VECTOR		100
#define ID_BUTTON_SAVE_NOW			101
#define ID_EDIT_FILE_NAME			102
#define ID_BUTTON_SAVE_DEFAULT_NOW  103

#define FIELD_VALUE(P_BOARD, X, Y, Z) P_BOARD[(Z) * boardFieldCountPlain + (Y) * boardSizeX + (X)]

// advance declarations
class CPreferencesWindow;
class CAICompetitionWindow;
class CLookUpTable;
class CNeuralNetwork;
class CNeuralNetworkWindow;

//! The main class, which provides for the user interface.
/*!
* The rendering loop and reaction on user events is done here.
*/
class CMuele : public IEventReceiver, public IC_Console
{
public:

	// constructor and destructor

	CMuele();
	~CMuele();

	// methods
	
	//! Sets the board to a new size.
	void resetBoard(bool keepNeuralNetwork);
	//! Clears the board for a new game.
	void restartBoard();
	//! Receives all events from Irrlicht.
	bool OnEvent(SEvent event);
	//! Creates a centered window.
	gui::IGUIWindow* createWindow(int sizeX, int sizeY, wchar_t *name);
	//! Creates a centered window with text and a OK button.
	gui::IGUIWindow* createInformationWindow(int sizeX, int sizeY, wchar_t *name, wchar_t *text);
	//! This method is called from the standart main method and starts the program.
	int run(char *argv[]);


	// variables

	CPreferencesWindow		*pPreferencesWindow;
	CAICompetitionWindow	*pAICompetitionWindow;
	CLookUpTable			*pLookUpTable;
	CNeuralNetwork			*pNeuralNetwork;
	CSymmetry				*pSymmetry;
	CNeuralNetworkWindow	*pNeuralNetworkWindow;
	
	char actualPlayer, lastPlayer;
	char actualPlayerType, lastPlayerType;
	char *pBoard;
	int  winFieldCount;
	int  boardSizeX, boardSizeY, boardSizeZ;
	int  boardFieldCount, boardFieldCountPlain;
	int  gameFinished;
	char playerOneType, playerTwoType;
	bool trainingRunning;

	video::IVideoDriver  *pDriver;
	gui::IGUIEnvironment *pGuiEnv;
	scene::ISceneManager *pSmgr;

private:

	// methods

	void switchActualPlayer(int moveOfActualPlayer);
	core::position2d<s32> getScreenCoordinatesFrom3DPosition(core::vector3df pos3d);

	// variables

	f32  boardFieldDistance;
	f32  halfBoardWidthX, halfBoardWidthY;
	int  selectedCylinder;
	int  winFieldCountTimesX;
	int  moveNumber;

	char *pWinnerBoard;
	int *pMoveHistory;

	video::SMaterial materialCylinder;
	video::SMaterial materialSphere[3];
	video::SMaterial materialSphereWon[3];
};

