/*
* Neural Networks Tearm Project
* Martin Johne
* 04.10.2006
*/
#pragma once
#include "LargeInteger.h"

//! Used to get a board which is a unique symmetrie under all possible symmetries of a game board.
class CSymmetry
{
public:

	//! The constructor needs the dimensions of the game board.
	CSymmetry(int boardSizeX, int boardSizeY, int boardSizeZ);
	~CSymmetry(void);

	//! Returns a pointer to a game board which is the unique symmetry out of all possible symmetries of the given game board.
	char* getSymmetry(char *pGameBoard);

private:

	void symmetryOriginal();
	void symmetryMirrorVertical();
	void symmetryMirrorHorizontal();
	void symmetryMirrorVerticalHorizontal();
	void symmetryRotateRight();
	void symmetryRotateRightMirrorVertical();
	void symmetryRotateLeft();
	void symmetryRotateLeftMirrorVertical();

	
	char *pBoard;
	char *pBoardSymmetry;
	int  boardSizeX, boardSizeY, boardSizeZ;
	int  boardFieldCount, boardFieldCountPlain;
	CLargeInteger *symmetryValue[8];
};
