/*
* Neural Networks Tearm Project
* Martin Johne
* 04.10.2006
*/
#pragma once

//! This class checks if a player won on a given game board.
class CTestWin
{
public:

	//! The constructor needs the game board properties and the player to test for a win.
	/*!
	*   The winning pieces are written into the game board pWinboard on call of testWin(), which is'nt cleared before.
	*	If returnImmediately is set to true the winning pieces are not written on call of testWin(),
	*	then pWinBoard can be NULL.
	*/
	CTestWin(const char *pBoard, char *pWinBoard, int boardSizeX, int boardSizeY, int boardSizeZ, char playerToTest, int winFieldCount, int returnImmediately);
	~CTestWin(void);
	//! Returns if the player given by the constructor won a game or not.
	bool testWin();

private:
	const char *pBoard;
	char *pWinnerBoard;
	int boardSizeX, boardSizeY, boardSizeZ;
	char whichPlayer;
	int returnImmediately;
	int  boardFieldCount, boardFieldCountPlain;
	int  winFieldCountTimesX;
	int  winFieldCount;
};
